<?php $__env->startSection('title', 'User List'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Users List</h5>
            <a class="btn btn-primary btn-sm" href="<?php echo e(route('users.create')); ?>">Add User</a>
          </div>
        <div class="card-body">
            <div class="table-responsive text-nowrap">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>SL</th>
                            
                            <th>User Id</th>
                            <th>Name</th>
                            <th>Role</th>
                            <th>Password</th>
                            <th>Card No</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                
                                <td><?php echo e($user['userid']); ?></td>
                                <td><?php echo e($user['name']); ?></td>
                                <td><?php echo e($user['role']); ?></td>
                                <td><?php echo e($user['password']); ?></td>
                                <td><?php echo e($user['cardno']); ?></td>
                                <td>
                                    <a class="btn btn-primary btn-sm" href="<?php echo e(route('users.show-single', $user)); ?>">
                                        View</a>

                                    <form method="POST" action="<?php echo e(route('users.destroy', $user['uid'])); ?>" class="d-inline">
                                        <?php echo method_field('DELETE'); ?>
                                        <?php echo csrf_field(); ?>

                                        <a class="btn btn-danger btn-sm" href="#"
                                            onclick="event.preventDefault();
                        this.closest('form').submit();">
                                            Delete</a>
                                    </form>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\Gpush\resources\views/pages/users/index.blade.php ENDPATH**/ ?>