<?php $__env->startSection('title', 'Device Information'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">

        <div class="d-flex justify-content-between align-items-center">
            <h5 class="card-header">Device List</h5>

            <h5 class="card-header">
                <a href="<?php echo e(route('devices.create')); ?>" class="btn btn-primary  mr-2">
                    <i class='bx bx-plus'></i> Add Device
                </a>
            </h5>

        </div>
        <div class="card-body">
            <div class="table-responsive text-nowrap">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Device Id</th>
                            <th>Device Name</th>
                            <th>Device IP Address</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $devices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $device): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($device->device_id); ?></td>
                                <td><?php echo e($device->name); ?></td>
                                <td><?php echo e($device->device_ip); ?></td>
                                <td>
                                    <a href="<?php echo e(route('devices.show', $device->id)); ?>" class="btn btn-sm btn-icon"><i
                                            class='bx bx-show'></i></a>
                                    <a href="<?php echo e(route('devices.edit', $device->id)); ?>" class="btn btn-sm btn-icon"><i
                                            class='bx bxs-edit-alt'></i></a>

                                    <button type="button" class="btn btn-sm btn-icon" onclick="openDeleteModal(this);"
                                        data-id="<?php echo e($device->id); ?>">
                                        <i class='bx bxs-trash'></i>
                                    </button>

                                    <form method="POST" id="<?php echo e($device->id); ?>"
                                        action="<?php echo e(route('devices.destroy', $device->id)); ?>" class="d-none">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>

                                    </form>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="4">No Data Found</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>


        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\Gpush-v2\resources\views/pages/devices/index.blade.php ENDPATH**/ ?>