<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Gpush</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,600&display=swap" rel="stylesheet" />

    <!-- Styles -->
    <style>
        body,
        html {
            height: 100%;
            margin: 0;
            padding: 0;
            font-family:'Franklin Gothic Medium', 'Arial Narrow', Arial, sans-serif
        }

        .bg {
            /* Center and scale the image nicely */
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
            /* The image used */
            background-image: url(<?php echo e(asset('images/bg.jpg')); ?>);

        }


        .btn-container{
            display: flex;
            justify-content: end;
            margin-top: 10px;
            margin-right: 20px;
            column-gap: 10px;
        }
        .btn{
            background: rgb(22, 22, 22);
            color: rgb(203, 203, 203);
            border: 1px solid black;
            border-radius: 5px;
            transition: .4s;
            text-decoration: none;
            padding: 8px 16px;

        }

        .btn:hover{
            background: rgb(236, 236, 236);
            color: black;
        }


    </style>
</head>

<body class="bg">
    <div>
        <?php if(Route::has('login')): ?>
            <div class="btn-container">
                <?php if(auth()->guard()->check()): ?>
                    <a href="<?php echo e(url('/dashboard')); ?>" class="">
                        <span>Dashboard</span>
                    </a>
                <?php else: ?>
                    <a href="<?php echo e(route('login')); ?>" class="btn">
                       Log in
                    </a>

                    
                <?php endif; ?>
            </div>
        <?php endif; ?>


    </div>
</body>

</html>
<?php /**PATH C:\laragon\www\Gpush\resources\views/welcome.blade.php ENDPATH**/ ?>