<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Attendance;

class AttendanceFetchAllDat extends Command
{
    protected $signature = 'attendance:fetch-all-dat';
    protected $description = 'Fetch all .DAT attendance files from C:\db and insert into MySQL';

    public function handle(): void
    {
        // $directory = 'C:\db';

        // // সব .DAT ফাইল খুঁজে বের করো
        // $files = glob($directory . '\DATA*.DAT');
        // if (!$files) {
        //     $this->error("No .DAT files found in $directory");
        //     return;
        // }

        $directory1 = 'C:\db';
        $directory2 = 'C:\db2';

        // দুই ফোল্ডারের .DAT ফাইল খুঁজে বের করো
        $files1 = glob($directory1 . '\DATA*.DAT');
        $files2 = glob($directory2 . '\DATA*.DAT');

        // Merge করে এক array বানাও
        $files = array_merge($files1 ?: [], $files2 ?: []);

        // Check করো ফাইল পাওয়া গেছে কিনা
        if (!$files) {
            $this->error("No .DAT files found in $directory1 or $directory2");
            return;
        }

        $totalInserted = 0;

        foreach ($files as $file) {
            $fileName = basename($file);

            // ফাইলনেম থেকে তারিখ বের করো
            // if (!preg_match('/DATA(\d{2})(\d{2})\.DAT/', $fileName, $matches)) {
            //     $this->warn("Skipping invalid file: $fileName");
            //     continue;
            // }

            // $month = $matches[1];
            // $day = $matches[2];
            // $year = date('Y');
            $inserted = 0;

            // ফাইল লাইন বাই লাইন পড়ো
            $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            foreach ($lines as $line) {
                $parts = explode(':', $line);
                if (count($parts) !== 6) continue;

                $badgeNumber = $parts[1];
                $date = $parts[2];
                $year = '20' . substr($date, 0, 2);
                $month = substr($date, 2, 2);
                $day = substr($date, 4, 2);

                $time = $parts[3]; // e.g., 104024

                // সময় ফরম্যাট করো
                $hh = substr($time, 0, 2);
                $mm = substr($time, 2, 2);
                $ss = substr($time, 4, 2);
                $datetime = "$year-$month-$day $hh:$mm:$ss";

                // ডুপ্লিকেট চেক
                $exists = Attendance::where('user_id', $badgeNumber)
                    ->where('punch_time', $datetime)
                    ->exists();

                if (!$exists) {
                    Attendance::create([
                        'user_id' => $badgeNumber,
                        'punch_time' => $datetime,
                    ]);
                    $inserted++;
                    $totalInserted++;
                }
            }

            $this->info("✅ $fileName processed. New records inserted: $inserted.");
        }

        $this->info("🎉 All files processed. Total new records inserted: $totalInserted.");
    }
}
